
import gurobi

def solve_nut_combo_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="Combo_X", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="Combo_Y", lb=0, ub=gurobi.GRB.INFINITY)

    # Set objective function
    model.setObjective(35 * x1 + 55 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.70 * x1 + 0.35 * x2 <= 35, name="almonds_constraint")
    model.addConstr(0.30 * x1 + 0.65 * x2 <= 20, name="hazelnuts_constraint")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Combo X = {x1.varValue} kg, Combo Y = {x2.varValue} kg")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_nut_combo_problem()
