
import gurobipy as gp

# Create a new model
m = gp.Model("fruit_investment")

# Create variables
apple = m.addVar(name="apple")
orange = m.addVar(name="orange")
pear = m.addVar(name="pear")
banana = m.addVar(name="banana")

# Set objective function
m.setObjective(0.05 * apple + 0.06 * orange + 0.03 * pear + 0.08 * banana, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(apple + orange + pear + banana <= 300000, "total_investment")
m.addConstr(banana <= apple, "banana_apple")
m.addConstr(orange <= pear, "orange_pear")
m.addConstr(banana <= 0.3 * (apple + orange + pear + banana), "banana_percentage")


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f"Apple Investment: {apple.x}")
    print(f"Orange Investment: {orange.x}")
    print(f"Pear Investment: {pear.x}")
    print(f"Banana Investment: {banana.x}")
    print(f"Total Return: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print(f"Optimization ended with status {m.status}")

