
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="apple", lb=0)
    x2 = model.addVar(name="orange", lb=0)
    x3 = model.addVar(name="pear", lb=0)
    x4 = model.addVar(name="banana", lb=0)

    # Objective function
    model.setObjective(0.05*x1 + 0.06*x2 + 0.03*x3 + 0.08*x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 + x3 + x4 <= 300000)
    model.addConstr(x1 - x4 >= 0)
    model.addConstr(x3 - x2 >= 0)
    model.addConstr(0.7*x4 - 0.3*x1 - 0.3*x2 - 0.3*x3 <= 0)

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment amounts:")
        print(f"Apple: ${x1.varValue:.2f}")
        print(f"Orange: ${x2.varValue:.2f}")
        print(f"Pear: ${x3.varValue:.2f}")
        print(f"Banana: ${x4.varValue:.2f}")
        print(f"Total return: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_investment_problem()
