
from gurobipy import Model, GRB

# Create a new model
model = Model("TV Commercials")

# Create variables
movies = model.addVar(vtype=GRB.INTEGER, name="movies")
sports = model.addVar(vtype=GRB.INTEGER, name="sports")
comedy = model.addVar(vtype=GRB.INTEGER, name="comedy")

# Set objective function
model.setObjective(25000 * movies + 100000 * sports + 45000 * comedy, GRB.MAXIMIZE)

# Add constraints
model.addConstr(1000 * movies + 5000 * sports + 2000 * comedy <= 50000, "Budget")
model.addConstr(sports <= 5, "SportsLimit")
model.addConstr(comedy <= (movies + sports + comedy) / 3, "ComedyLimit")
model.addConstr(movies >= 0.15 * (movies + sports + comedy), "MoviesMinimum")
model.addConstr(movies >=0, "NonNegativityMovies")
model.addConstr(sports >=0, "NonNegativitySports")
model.addConstr(comedy >=0, "NonNegativityComedy")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal audience reach: {model.objVal}")
    print(f"Number of movie commercials: {movies.x}")
    print(f"Number of sports commercials: {sports.x}")
    print(f"Number of comedy commercials: {comedy.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

