
import gurobi

def solve_tv_commercial_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="movies", vtype=gurobi.GRB.INTEGER)  # commercials during movies
    x2 = model.addVar(name="sports", vtype=gurobi.GRB.INTEGER)  # commercials during sports games
    x3 = model.addVar(name="comedy", vtype=gurobi.GRB.INTEGER)  # commercials during comedy shows

    # Objective function: Maximize audience reach
    model.setObjective(25000*x1 + 100000*x2 + 45000*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(1000*x1 + 5000*x2 + 2000*x3 <= 50000, name="budget_constraint")
    model.addConstr(x2 <= 5, name="sports_limit")
    model.addConstr(2*x3 <= x1 + x2, name="comedy_limit")
    model.addConstr(0.85*x1 >= 0.15*x2 + 0.15*x3, name="movie_minimum")
    model.addConstr(x1 >= 0, name="x1_non_negative")
    model.addConstr(x2 >= 0, name="x2_non_negative")
    model.addConstr(x3 >= 0, name="x3_non_negative")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Commercials during movies: {x1.varValue}")
        print(f"Commercials during sports games: {x2.varValue}")
        print(f"Commercials during comedy shows: {x3.varValue}")
        print(f"Max audience reach: {25000*x1.varValue + 100000*x2.varValue + 45000*x3.varValue}")
    else:
        print("No optimal solution found.")

solve_tv_commercial_problem()
