
import gurobipy as gp

# Create a new model
model = gp.Model("Candy Mix")

# Create variables
cherry = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="cherry") # Number of sour cherry candies
peach = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="peach")   # Number of sour peach candies

# Set objective function
model.setObjective(0.10 * cherry + 0.12 * peach, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * cherry + peach >= 50, "Citric Acid")
model.addConstr(3 * cherry + 4 * peach >= 60, "Sugar")
model.addConstr(cherry <= 10, "Cherry Limit")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of sour cherry candies: {cherry.x}")
    print(f"Number of sour peach candies: {peach.x}")
    print(f"Minimum Cost: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

