
from gurobipy import *

# Create a new model
m = Model("candy_mix")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="sour_cherry_candies", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="sour_peach_candies", lb=0)

# Set the objective function
m.setObjective(0.10*x1 + 0.12*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + x2 >= 50, "citric_acid_constraint")
m.addConstr(3*x1 + 4*x2 >= 60, "sugar_constraint")
m.addConstr(x1 <= 10, "max_sour_cherry_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of sour cherry candies: {x1.x}")
    print(f"Number of sour peach candies: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
