
import gurobipy as gp

# Create a new model
model = gp.Model("CandyMix")

# Define the variables
x1 = model.addVar(name="sour_cherry_candies", lb=0, ub=10, obj=0.10)
x2 = model.addVar(name="sour_peach_candies", lb=0, obj=0.12)

# Add constraints
model.addConstr(2*x1 + x2 >= 50, name="citric_acid")
model.addConstr(3*x1 + 4*x2 >= 60, name="sugar")

# Set the upper bound for x1
model.addConstr(x1 <= 10, name="sour_cherry_limit")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Sour cherry candies: {x1.varValue}")
    print(f"Sour peach candies: {x2.varValue}")
    print(f"Total cost: {model.objVal}")
else:
    print("No optimal solution found.")
