
import gurobipy as gp

# Create a new model
m = gp.Model("sports_warehouse")

# Create variables
hockey_nets = m.addVar(vtype=gp.GRB.INTEGER, name="hockey_nets")
basketball_hoops = m.addVar(vtype=gp.GRB.INTEGER, name="basketball_hoops")

# Set objective function
m.setObjective(50 * hockey_nets + 75 * basketball_hoops, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * hockey_nets + 3 * basketball_hoops <= 300, "space_constraint")
m.addConstr(100 * hockey_nets + 150 * basketball_hoops <= 10000, "budget_constraint")
m.addConstr(hockey_nets >= 0.65 * (hockey_nets + basketball_hoops), "hockey_proportion_constraint")
m.addConstr(hockey_nets >= 0, "hockey_non_negativity")
m.addConstr(basketball_hoops >= 0, "basketball_non_negativity")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of hockey nets: {hockey_nets.x}")
    print(f"Number of basketball hoops: {basketball_hoops.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

