
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="hockey_nets", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="basketball_hoops", lb=0, vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(50*x1 + 75*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(5*x1 + 3*x2 <= 300, name="space_constraint")
    model.addConstr(100*x1 + 150*x2 <= 10000, name="budget_constraint")
    model.addConstr(x1 - 1.8571*x2 >= 0, name="hockey_net_proportion_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hockey nets: {x1.varValue}")
        print(f"Basketball hoops: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
