
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("lab_staffing")

# Create variables
undergrad = m.addVar(lb=0, vtype=GRB.INTEGER, name="undergrad")
grad = m.addVar(lb=0, vtype=GRB.INTEGER, name="grad")

# Set objective function
m.setObjective(100 * undergrad + 300 * grad, GRB.MINIMIZE)

# Add constraints
m.addConstr(undergrad + grad >= 50, "total_students")
m.addConstr(grad >= 10, "min_grad")
m.addConstr(grad >= (1/3) * undergrad, "grad_ratio")


# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal weekly wage: ${m.objVal:.2f}")
    print(f"Number of undergraduate students: {undergrad.x}")
    print(f"Number of graduate students: {grad.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

