
from gurobipy import *

# Create a new model
m = Model("lab_students")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="undergraduate_students", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="graduate_students", lb=0)

# Set the objective function
m.setObjective(100*x1 + 300*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + x2 >= 50, "total_students")
m.addConstr(x2 >= 10, "minimum_graduate_students")
m.addConstr(x2 >= (1/3)*x1, "graduate_to_undergraduate_ratio")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Undergraduate students: {x1.x}")
    print(f"Graduate students: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
