
import gurobi

def solve_lab_employment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='undergraduate_students', lb=0, vtype=gurobi.GRB.INTEGER)  # Number of undergraduate students
    x2 = model.addVar(name='graduate_students', lb=0, vtype=gurobi.GRB.INTEGER)  # Number of graduate students

    # Objective function: Minimize weekly wages
    model.setObjective(100 * x1 + 300 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 + x2 >= 50, name='total_students')  # At least 50 students
    model.addConstr(x2 >= 10, name='graduate_students_min')  # At least 10 graduate students
    model.addConstr(x2 >= (1/3) * x1, name='graduate_to_undergraduate_ratio')  # Graduate students >= 1/3 of undergraduate students

    # Optimize the model
    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print(f"Optimal Solution: Undergraduate Students = {x1.varValue}, Graduate Students = {x2.varValue}")
        print(f"Minimum Weekly Wages: ${100 * x1.varValue + 300 * x2.varValue}")
    else:
        print("The problem is infeasible.")

solve_lab_employment_problem()
