
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("spice_cabinet_optimization")

    # Create variables
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="small_cabinets") # number of small cabinets
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="large_cabinets") # number of large cabinets


    # Set objective function
    m.setObjective(30*x1 + 40*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4*x1 + 8*x2 <= 200, "space_constraint")
    m.addConstr(70*x1 + 120*x2 <= 1400, "budget_constraint")


    # Optimize model
    m.optimize()

    # Print results
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))

    print('Obj: %g' % m.objVal)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

