
from gurobipy import *

# Create a new model
m = Model("Cabinet_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="small_cabinets")
x2 = m.addVar(vtype=GRB.INTEGER, name="large_cabinets")

# Set the objective function
m.setObjective(30*x1 + 40*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 8*x2 <= 200, "space_constraint")
m.addConstr(70*x1 + 120*x2 <= 1400, "budget_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of small cabinets: {x1.x}")
    print(f"Number of large cabinets: {x2.x}")
    print(f"Total seasonings and spices that can be stored: {30*x1.x + 40*x2.x}")
else:
    print("No optimal solution found")
