
import gurobi

def solve_cabinet_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="small_cabinets", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="large_cabinets", vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 30*x1 + 40*x2
    model.setObjective(30*x1 + 40*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4*x1 + 8*x2 <= 200, name="space_constraint")
    model.addConstr(70*x1 + 120*x2 <= 1400, name="budget_constraint")
    model.addConstr(x1 >= 0, name="x1_nonneg")
    model.addConstr(x2 >= 0, name="x2_nonneg")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of small cabinets: {x1.varValue}")
        print(f"Number of large cabinets: {x2.varValue}")
        print(f"Total seasonings and spices: {30*x1.varValue + 40*x2.varValue}")
    else:
        print("No optimal solution found.")

solve_cabinet_problem()
