
import gurobipy as gp

# Create a new model
m = gp.Model("Omega Seafood Optimization")

# Create variables
indian_ocean_days = m.addVar(lb=0, name="indian_ocean_days")
arctic_ocean_days = m.addVar(lb=0, name="arctic_ocean_days")


# Set objective function
m.setObjective(6000 * indian_ocean_days + 9000 * arctic_ocean_days, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3.4 * indian_ocean_days + 6 * arctic_ocean_days >= 20, "fish_constraint")
m.addConstr(2.2 * indian_ocean_days + 5 * arctic_ocean_days >= 12, "crab_constraint")
m.addConstr(1.5 * indian_ocean_days + 3 * arctic_ocean_days >= 10, "shrimp_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${m.objVal}")
    print(f"Days fishing in Indian Ocean: {indian_ocean_days.x}")
    print(f"Days fishing in Arctic Ocean: {arctic_ocean_days.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

