
from gurobipy import *

# Create a model
m = Model("Omega_Seafood")

# Define the variables
x1 = m.addVar(lb=0, name="days_fishing_Indian")
x2 = m.addVar(lb=0, name="days_fishing_Arctic")

# Set the objective function
m.setObjective(6000*x1 + 9000*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3.4*x1 + 6*x2 >= 20, "fish_demand")
m.addConstr(2.2*x1 + 5*x2 >= 12, "crab_demand")
m.addConstr(1.5*x1 + 3*x2 >= 10, "shrimp_demand")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Days fishing in Indian ocean: {x1.x}")
    print(f"Days fishing in Arctic ocean: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
