
import gurobi

def solve_omega_seafood_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='x1', lb=0, ub=gurobi.GRB.INFINITY)  # days in Indian ocean
    x2 = model.addVar(name='x2', lb=0, ub=gurobi.GRB.INFINITY)  # days in Arctic ocean

    # Define objective function
    model.setObjective(6000*x1 + 9000*x2, gurobi.GRB.MINIMIZE)

    # Define constraints
    model.addConstr(3.4*x1 + 6*x2 >= 20, name='fish_constraint')
    model.addConstr(2.2*x1 + 5*x2 >= 12, name='crab_constraint')
    model.addConstr(1.5*x1 + 3*x2 >= 10, name='shrimp_constraint')

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("The model is infeasible")

solve_omega_seafood_problem()
