
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("tree_planting")

# Create variables
oak = m.addVar(name="oak")
elm = m.addVar(name="elm")

# Set objective function
m.setObjective(1000*oak + 1200*elm, GRB.MAXIMIZE)

# Add constraints
m.addConstr(oak + elm <= 300, "Total_acres")
m.addConstr(oak >= 50, "Min_oak")
m.addConstr(elm >= 70, "Min_elm")
m.addConstr(elm <= 2*oak, "Elm_oak_ratio")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Oak trees: {oak.x} acres")
    print(f"  Elm trees: {elm.x} acres")
    print(f"  Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

