
from gurobipy import *

# Create a new model
m = Model("Tree_Planting")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oak_trees")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="elm_trees")

# Set the objective function
m.setObjective(1000*x1 + 1200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 300, "total_land")
m.addConstr(x1 >= 50, "min_oak")
m.addConstr(x2 >= 70, "min_elm")
m.addConstr(x2 <= 2*x1, "elm_to_oak_ratio")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
