
import gurobipy as gp

# Create a new model
model = gp.Model("Tree_Optimization")

# Define the variables
x1 = model.addVar(name="oak_trees", lb=0, ub=300, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="elm_trees", lb=0, ub=300, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize profit
model.setObjective(1000*x1 + 1200*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + x2 <= 300, name="total_acres")
model.addConstr(x1 >= 50, name="min_oak_trees")
model.addConstr(x2 >= 70, name="min_elm_trees")
model.addConstr(x2 <= 2*x1, name="elm_to_oak_ratio")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal acres of oak trees: {x1.varValue}")
    print(f"Optimal acres of elm trees: {x2.varValue}")
    print(f"Maximal profit: {model.objVal}")
else:
    print("The model is infeasible.")
