
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("electronics_store")

# Create variables
monitors = m.addVar(vtype=GRB.CONTINUOUS, name="monitors")
gaming_stations = m.addVar(vtype=GRB.CONTINUOUS, name="gaming_stations")


# Set objective function
m.setObjective(40 * monitors + 80 * gaming_stations, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * monitors + 12 * gaming_stations <= 150, "floor_space")
m.addConstr(gaming_stations >= 0.4 * (monitors + gaming_stations), "marketing")
m.addConstr(180 * monitors + 260 * gaming_stations <= 4000, "capital")
m.addConstr(monitors >= 0, "non_negativity_monitors")  # Explicit non-negativity constraints
m.addConstr(gaming_stations >= 0, "non_negativity_gaming_stations")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of monitors: {monitors.x:.2f}")
    print(f"Number of gaming stations: {gaming_stations.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

