
from gurobipy import *

# Create a new model
m = Model("Electronics_Store_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="monitors")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="gaming_stations")

# Set the objective function
m.setObjective(40*x1 + 80*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x1 + 12*x2 <= 150, "floor_space")
m.addConstr(1.5*x2 >= x1, "marketing_requirement")
m.addConstr(180*x1 + 260*x2 <= 4000, "capital")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: monitors = {x1.x}, gaming_stations = {x2.x}")
    print(f"Maximum profit: ${40*x1.x + 80*x2.x}")
else:
    print("No optimal solution found")
