
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="monitors", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="gaming_stations", lb=0, vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(40 * x1 + 80 * x2, gurobi.GRB.MAXIMIZE)

    # Add the constraints
    model.addConstr(8 * x1 + 12 * x2 <= 150, name="floor_space")
    model.addConstr(0.4 * x1 - 0.6 * x2 <= 0, name="marketing_requirement")
    model.addConstr(180 * x1 + 260 * x2 <= 4000, name="capital")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Monitors: {x1.varValue}")
        print(f"Gaming Stations: {x2.varValue}")
        print(f"Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
