
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("Natural_Pharmacy")

    # Create variables
    alpha = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="alpha") # bottles of Alpha
    beta = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="beta") # bottles of Beta


    # Set objective function
    m.setObjective(4*alpha + 6*beta, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(15*alpha + 25*beta <= 2000, "extract_constraint")
    m.addConstr(alpha >= 3*beta, "demand_constraint")
    m.addConstr(beta >= 10, "min_beta_constraint")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal profit: ${m.objVal:.2f}")
        print(f"Number of Alpha bottles: {alpha.x}")
        print(f"Number of Beta bottles: {beta.x}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
