
from gurobipy import *

# Create a new model
m = Model("Natural_Pharmacy")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Alpha_Bottles")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Beta_Bottles")

# Set the objective function
m.setObjective(4*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x1 + 25*x2 <= 2000, "Extract_Availability")
m.addConstr(x1 >= 3*x2, "Demand_Requirement")
m.addConstr(x2 >= 10, "Minimum_Beta_Production")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal Solution Found:")
    print(f"Number of Alpha bottles: {x1.x}")
    print(f"Number of Beta bottles: {x2.x}")
else:
    print("No optimal solution found")
