
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='Alpha', lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='Beta', lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 4*x1 + 6*x2
    model.setObjective(4*x1 + 6*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(15*x1 + 25*x2 <= 2000, name='extract_constraint')
    model.addConstr(x1 >= 3*x2, name='demand_constraint')
    model.addConstr(x2 >= 10, name='min_beta_constraint')

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Alpha = {x1.varValue}, Beta = {x2.varValue}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
