
import gurobipy as gp

# Create a new model
model = gp.Model("sandwich_optimization")

# Create variables
x1 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="peanut_butter_sandwiches")
x2 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chocolate_spread_sandwiches")


# Set objective function
model.setObjective(3 * x1 + 2 * x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 + x2 <= 150, "total_sandwiches")
model.addConstr(x1 >= 45, "min_peanut_butter")
model.addConstr(x2 >= 65, "min_chocolate_spread")
model.addConstr(x1 <= 80, "max_peanut_butter")
model.addConstr(x2 <= 100, "max_chocolate_spread")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal}")
    print(f"Number of peanut butter sandwiches: {x1.x}")
    print(f"Number of chocolate spread sandwiches: {x2.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

