
from gurobipy import *

# Create a new model
m = Model("Sandwich_Problem")

# Create variables
x1 = m.addVar(lb=45, ub=80, name="peanut_butter_sandwiches")
x2 = m.addVar(lb=65, ub=100, name="chocolate_spread_sandwiches")

# Set the objective function to maximize profit
m.setObjective(3*x1 + 2*x2, GRB.MAXIMIZE)

# Add constraint: total sandwiches cannot exceed 150
m.addConstr(x1 + x2 <= 150, name="total_sandwiches_limit")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Peanut butter sandwiches: {x1.x}")
    print(f"Chocolate spread sandwiches: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
