
import gurobipy as gp

# Create a new model
m = gp.Model("Sandwich_Optimization")

# Define the variables
x1 = m.addVar(name="peanut_butter_sandwiches", lb=0, ub=gp.GRB.INFINITY)
x2 = m.addVar(name="chocolate_spread_sandwiches", lb=0, ub=gp.GRB.INFINITY)

# Objective function: Maximize 3*x1 + 2*x2
m.setObjective(3*x1 + 2*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 <= 150, name="total_sandwiches")
m.addConstr(x1 >= 45, name="min_peanut_butter")
m.addConstr(x2 >= 65, name="min_chocolate_spread")
m.addConstr(x1 <= 80, name="max_peanut_butter")
m.addConstr(x2 <= 100, name="max_chocolate_spread")

# Solve the model
m.solve()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Peanut Butter Sandwiches: {x1.varValue}")
    print(f"Chocolate Spread Sandwiches: {x2.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("The model is infeasible or unbounded.")
