
import gurobipy as gp

# Create a new model
m = gp.Model("sandwich_optimization")

# Create variables
tuna = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tuna") # Tuna salad sandwiches
chicken = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken") # Chicken salad sandwiches


# Set objective function: Minimize cost
m.setObjective(5 * tuna + 7 * chicken, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(20 * tuna + 25 * chicken >= 100, "protein_req") # Protein requirement
m.addConstr(25 * tuna + 15 * chicken >= 150, "fat_req") # Fat requirement


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${m.objVal}")
    print(f"Number of tuna salad sandwiches: {tuna.x}")
    print(f"Number of chicken salad sandwiches: {chicken.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

