
from gurobipy import *

# Create a new model
m = Model("Weight_Gain_Problem")

# Define variables
x1 = m.addVar(name="tuna_salad_sandwiches", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="chicken_salad_sandwiches", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(5*x1 + 7*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(20*x1 + 25*x2 >= 100, name="protein_requirement")
m.addConstr(25*x1 + 15*x2 >= 150, name="fat_requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of tuna salad sandwiches: {x1.x}")
    print(f"Number of chicken salad sandwiches: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
