
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="tuna_salad_sandwiches", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="chicken_salad_sandwiches", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: minimize 5*x1 + 7*x2
    model.setObjective(5 * x1 + 7 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(20 * x1 + 25 * x2 >= 100, name="protein_constraint")
    model.addConstr(25 * x1 + 15 * x2 >= 150, name="fat_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Tuna salad sandwiches: {x1.varValue}")
        print(f"Chicken salad sandwiches: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
