
import gurobipy as gp

# Create a new model
m = gp.Model("countertop_production")

# Create variables
marble = m.addVar(vtype=gp.GRB.CONTINUOUS, name="marble")
granite = m.addVar(vtype=gp.GRB.CONTINUOUS, name="granite")

# Set objective function
m.setObjective(500 * marble + 750 * granite, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1 * marble + 1.5 * granite <= 300, "cutting_constraint")
m.addConstr(2 * marble + 3 * granite <= 500, "polishing_constraint")
m.addConstr(marble >= 0, "marble_nonnegativity")
m.addConstr(granite >= 0, "granite_nonnegativity")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Marble Countertops: {marble.x}")
    print(f"  Granite Countertops: {granite.x}")
    print(f"  Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

