
from gurobipy import *

# Create a new model
m = Model("Countertops")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="marble_countertops")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="granite_countertops")

# Set the objective function
m.setObjective(500*x1 + 750*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + 1.5*x2 <= 300, "cutting_time")
m.addConstr(2*x1 + 3*x2 <= 500, "polishing_time")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Marble Countertops: {x1.x}")
    print(f"Granite Countertops: {x2.x}")
    print(f"Maximum Profit: ${500*x1.x + 750*x2.x:.2f}")
else:
    print("No optimal solution found")
