
import gurobipy as gp

# Create a new model
model = gp.Model("Countertops_Optimization")

# Define variables
x1 = model.addVar(name="marble_countertops", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="granite_countertops", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function
model.setObjective(500*x1 + 750*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + 1.5*x2 <= 300, name="cutting_hours_constraint")
model.addConstr(2*x1 + 3*x2 <= 500, name="polishing_hours_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal number of marble countertops: {x1.varValue}")
    print(f"Optimal number of granite countertops: {x2.varValue}")
    print(f"Maximal profit: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
