
from gurobipy import *

# Create a new model
m = Model("phone_production")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="touchscreen_phones")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="flip_phones")

# Set the objective function
m.setObjective(150*x1 + 200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x1 + 80*x2 <= 5000, "hardware_setup")
m.addConstr(20*x1 + 15*x2 <= 3750, "software_verification")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Touchscreen phones: {x1.x}")
    print(f"Flip phones: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
