
import gurobipy as gp

# Create a new model
model = gp.Model("Phone_Production")

# Define variables
x1 = model.addVar(name="touchscreen_phones", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="flip_phones", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize profit
model.setObjective(150*x1 + 200*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(30*x1 + 80*x2 <= 5000, name="hardware_setup")
model.addConstr(20*x1 + 15*x2 <= 3750, name="software_verification")

# Solve the model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Max Profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
