
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
peaches = m.addVar(lb=0, name="peaches")  # Acres of peaches
nectarines = m.addVar(lb=0, name="nectarines")  # Acres of nectarines

# Set objective function: Maximize profit
m.setObjective(300 * peaches + 350 * nectarines, GRB.MAXIMIZE)

# Add constraints
m.addConstr(40 * peaches + 50 * nectarines <= 1350, "bug_spray_cost")  # Bug spray cost constraint
m.addConstr(50 * peaches + 70 * nectarines <= 2000, "bug_spray_time")  # Bug spray time constraint
m.addConstr(peaches + nectarines <= 30, "land_constraint")  # Land constraint


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print(f"Optimal Solution:")
    print(f"  Peaches: {peaches.x:.2f} acres")
    print(f"  Nectarines: {nectarines.x:.2f} acres")
    print(f"  Maximum Profit: ${m.objVal:.2f}")

