
from gurobipy import *

# Create a new model
m = Model("Peaches_and_Nectarines")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="acres_of_peaches")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="acres_of_nectarines")

# Set the objective function
m.setObjective(300*x1 + 350*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(40*x1 + 50*x2 <= 1350, "bug_spray_budget")
m.addConstr(50*x1 + 70*x2 <= 2000, "spray_time_limit")
m.addConstr(x1 + x2 <= 30, "total_land")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of peaches: {x1.x}")
    print(f"Acres of nectarines: {x2.x}")
    print(f"Maximum profit: ${300*x1.x + 350*x2.x:.2f}")
else:
    print("No optimal solution found")
