
import gurobipy as gp

# Create a new model
model = gp.Model("Peaches_and_Nectarines")

# Define variables
x1 = model.addVar(name="peaches", lb=0)  # Acres of peaches
x2 = model.addVar(name="nectarines", lb=0)  # Acres of nectarines

# Objective function: Maximize profit
model.setObjective(300*x1 + 350*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(40*x1 + 50*x2 <= 1350, name="bug_spray_cost")  # Bug-spray cost constraint
model.addConstr(50*x1 + 70*x2 <= 2000, name="spray_time")  # Time to spray bug-spray constraint
model.addConstr(x1 + x2 <= 30, name="land_availability")  # Acres of land constraint

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal acres of peaches: {x1.varValue}")
    print(f"Optimal acres of nectarines: {x2.varValue}")
    print(f"Maximal profit: {model.objVal}")
else:
    print("The model is infeasible.")
