
import gurobipy as gp

# Create a new model
model = gp.Model("WatchProduction")

# Create variables
round_watches = model.addVar(vtype=gp.GRB.INTEGER, name="round_watches")
square_watches = model.addVar(vtype=gp.GRB.INTEGER, name="square_watches")


# Set objective function
model.setObjective(1000 * round_watches + 1250 * square_watches, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(round_watches <= 5, "Team A Capacity")
model.addConstr(square_watches <= 6, "Team B Capacity")
model.addConstr(round_watches + square_watches <= 8, "Quality Check Capacity")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found. Profit: ${model.objVal}")
    print(f"Round Watches: {round_watches.x}")
    print(f"Square Watches: {square_watches.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

