
from gurobipy import *

# Create a new model
m = Model("Watch_Production")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="round_watches")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="square_watches")

# Set the objective function
m.setObjective(1000*x1 + 1250*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 5, "team_a_capacity")
m.addConstr(x2 <= 6, "team_b_capacity")
m.addConstr(x1 + x2 <= 8, "quality_check_limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Round watches: {x1.x}")
    print(f"Square watches: {x2.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
