
import gurobipy as gp

# Create a new model
model = gp.Model("Watch_Production")

# Define the variables
x1 = model.addVar(name="round_watches", lb=0, ub=5, vtype=gp.GRB.INTEGER)  # Round watches
x2 = model.addVar(name="square_watches", lb=0, ub=6, vtype=gp.GRB.INTEGER)  # Square watches

# Objective function: Maximize profit
model.setObjective(1000*x1 + 1250*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 <= 5, name="Team_A_capacity")
model.addConstr(x2 <= 6, name="Team_B_capacity")
model.addConstr(x1 + x2 <= 8, name="Watchmaker_capacity")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: Round watches = {x1.varValue}, Square watches = {x2.varValue}")
    print(f"Max Profit: ${1000*x1.varValue + 1250*x2.varValue}")
else:
    print("No optimal solution found")
