
import gurobipy as gp

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
clean_water = m.addVar(name="clean_water")
electricity = m.addVar(name="electricity")

# Set objective function
m.setObjective(1.9 * clean_water + 2.3 * electricity, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(clean_water + electricity <= 5500, "budget_constraint")
m.addConstr(clean_water >= 1000, "clean_water_min")
m.addConstr(electricity >= 0.3 * (clean_water + electricity), "electricity_min_percent")
m.addConstr(clean_water >=0, "clean_water_non_negative")
m.addConstr(electricity >=0, "electricity_non_negative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Invest ${clean_water.x:.2f} in clean water")
    print(f"Invest ${electricity.x:.2f} in electricity")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

