
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="clean_water")
x2 = m.addVar(lb=0, name="electricity")

# Set the objective function
m.setObjective(1.9*x1 + 2.3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 5500, "budget")
m.addConstr(x1 >= 1000, "clean_water_min")
m.addConstr(7*x2 >= 3*x1, "electricity_percentage")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Amount invested in clean water: {x1.x}")
    print(f"Amount invested in electricity: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
