
import gurobi

def solve_infrastructure_investment():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="clean_water", lb=0)  # Investment in clean water
    x2 = model.addVar(name="electricity", lb=0)  # Investment in electricity

    # Objective function: Maximize 1.9*x1 + 2.3*x2
    model.setObjective(1.9 * x1 + 2.3 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 5500, name="budget_constraint")
    model.addConstr(x1 >= 1000, name="clean_water_constraint")
    model.addConstr(-0.3 * x1 + 0.7 * x2 >= 0, name="electricity_constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Investment in clean water: ${x1.varValue:.2f}")
        print(f"Investment in electricity: ${x2.varValue:.2f}")
        print(f"Total Profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible")

solve_infrastructure_investment()
