
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("vessel_production")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="general_purpose")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="pharmaceutical")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="pressure")


# Set objective function
m.setObjective(2000*x1 + 3000*x2 + 4500*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3.5*x1 + 4*x2 + 2*x3 <= 120, "iron_ore_constraint")
m.addConstr(2*x1 + 5*x2 + 3.5*x3 <= 70, "zinc_ore_constraint")
m.addConstr(x1 >= 0, "general_purpose_nonnegativity")
m.addConstr(x2 >= 0, "pharmaceutical_nonnegativity")
m.addConstr(x3 >= 0, "pressure_nonnegativity")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"General purpose vessels: {x1.x:.2f}")
    print(f"Pharmaceutical vessels: {x2.x:.2f}")
    print(f"Pressure vessels: {x3.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

