
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="general_purpose_vessels", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="pharmaceutical_vessels", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x3 = model.addVar(name="pressure_vessels", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(2000*x1 + 3000*x2 + 4500*x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3.5*x1 + 4*x2 + 2*x3 <= 120, name="iron_ore_constraint")
    model.addConstr(2*x1 + 5*x2 + 3.5*x3 <= 70, name="zinc_ore_constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"General purpose vessels: {x1.varValue}")
        print(f"Pharmaceutical vessels: {x2.varValue}")
        print(f"Pressure vessels: {x3.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
